jQuery(document).ready(function($) {

    jQuery('#applyGiftCard').click(function() {
        event.preventDefault();
        var giftCardCode = jQuery('#giftCardCode').val();

        jQuery.ajax({
            type: 'POST',
            url: ajax_object.ajax_url,
            data: {
                action: 'apply_gift_card',
                giftCardCode: giftCardCode,
            },
            dataType: 'json',
            success: function(response) {
                console.log(response);
                jQuery('body').trigger('update_checkout');
                if (response.success) {
                    jQuery('.error-msg').hide();
                    jQuery('#message').show();
                    jQuery('#message .bottom-msg').text(response.data.message);
                    jQuery('#message #gift-price').text(response.data.gift_currency+' ' + response.data.gift_card_value);
                    jQuery('#giftCardField .top-header, #giftCardField .custom-input-box').hide();
                }else
                {
                    jQuery('.error-msg').text(response.data.message);
                    jQuery('.error-msg').show();
                }
                /*if (response.updated_total) {
                    jQuery('#checkoutTotal').text('Updated Total: ' + response.updated_total);
                }*/
            },
            error: function(xhr) {
                console.log('error');
                jQuery('.error-msg').text(xhr.message);
                jQuery('.error-msg').show();
            }
        });
    });
});


jQuery(document).ready(function($) {
    // Handle click event on the remove button
    $(document).on('click', '.remove-cardivo-gift-card', function(e) {
        e.preventDefault();
        // Perform AJAX call to unset the session and remove the value
        $.ajax({
            url: ajax_object.ajax_url,
            type: 'POST',
            data: {
                action: 'remove_cardivo_gift_card' // Action hook for PHP function
            },
            success: function(response) {
                // Reload the page or perform any other action
                jQuery('.error-msg').hide();
                jQuery('body').trigger('update_checkout');
                jQuery('#message').hide();
                jQuery('#giftCardField .top-header, #giftCardField .custom-input-box').show();
            },
            error: function(error) {
                console.log(error); // Handle errors if any
            }
        });
    });

    $("#redeem-gift-card").click(function(){
        $(".custom-input-box").toggle('fade');
    });

});
